function [Rh, Rhb] = get_sample_K(simPar)
    h = zeros(simPar.N,simPar.T_pre+simPar.T);
simPar.nCovSample = 100;
Rh = zeros(simPar.N*simPar.T);
Rhb = zeros(simPar.N*simPar.T_pre,simPar.N*simPar.T);
if simPar.channel.genMethod == "CDL"
    cdl_model = nrCDLChannel('ChannelFiltering', false);
    cdl_model.MaximumDopplerShift       = 2*simPar.v/simPar.lambda;
    cdl_model.UTDirectionOfTravel       = [0;0];
    cdl_model.CarrierFrequency          = simPar.fc;
    cdl_model.SampleRate                = 1/simPar.Ts;
    cdl_model.SampleDensity             = Inf;
    cdl_model.NumTimeSamples            = simPar.T+simPar.T_pre;
    cdl_model.TransmitAntennaArray.Size = [simPar.N, 1, 1, 1, 1];   % [M N P Mg Ng]
    cdl_model.ReceiveAntennaArray.Size  = [1, 1, 1, 1, 1]; 
    cdl_model.Seed                      = randi(10000);
    [pathGains, ~] = cdl_model();
    for idxc = 1:simPar.T+simPar.T_pre
         h1(:,idxc) = reshape(sum(pathGains(idxc, :, :, :), 2), [simPar.N, 1]);
    end
    h = h1;
end
%     hMatl = zeros(simPar.N*simPar.T, simPar.nCovSample); 
%     hMatf = zeros(simPar.N*simPar.T_pre, simPar.nCovSample);
        for idx = 1:simPar.nCovSample
            [pathGains, ~] = cdl_model();
            h = reshape(sum(pathGains(1, :, :, :), 2), [simPar.N, 1]);
            [pathGains, ~] = cdl_model();
            for idxc = 1:simPar.T+simPar.T_pre
                h1(:,idxc) = reshape(sum(pathGains(idxc, :, :, :), 2), [simPar.N, 1]);
            end
            h = h1;
            h = h + sqrt(simPar.sigma2_n)*(randn([simPar.N, 1]) + 1i*randn([simPar.N, 1]))/sqrt(2); 
            hl= h(1:simPar.N*simPar.T);
            hf= h(simPar.N*simPar.T+1:end);
%             hMat(:,idx) = h; 

            Rh = Rh + hl*hl';
            Rhb = Rhb + hf*hl';
        end
end



